<?php

class EWRporta_Block_RecentNews extends XenForo_Model
{
	public function getModule(&$options, $page)
	{
		$page = ($page - 1) * $options['recentnews_limit'];

		$news = $this->_getDb()->fetchAll("
			SELECT xf_thread.*, xf_user.*, xf_post.message, xf_post.attach_count, xf_node.title AS node_title,
				IF(xf_user.username IS NULL, xf_thread.username, xf_user.username) AS username,
				IF(EWRporta_promotes.promote_date IS NULL, xf_thread.post_date, EWRporta_promotes.promote_date) AS promote_date
			FROM xf_thread
				LEFT JOIN xf_user ON (xf_user.user_id = xf_thread.user_id)
				INNER JOIN xf_post ON (xf_post.post_id = xf_thread.first_post_id)
				INNER JOIN xf_node ON (xf_node.node_id = xf_thread.node_id)
				LEFT JOIN EWRporta_promotes ON (EWRporta_promotes.thread_id = xf_thread.thread_id)
			WHERE (xf_thread.node_id IN (".$options['recentnews_forum'].") OR EWRporta_promotes.promote_date < ?)
				AND xf_thread.discussion_state = 'visible'
			ORDER BY promote_date DESC
			LIMIT ?, ?
		", array(XenForo_Application::$time, $page, $options['recentnews_limit']));

		foreach ($news AS &$post)
		{
			if ($post['attach_count'])
			{
				$post['attachments'] = $this->getModelFromCache('XenForo_Model_Attachment')->getAttachmentsByContentId('post', $post['first_post_id']);
				$post['attachments'] = $this->getModelFromCache('XenForo_Model_Attachment')->prepareAttachments($post['attachments']);
			}

			$post = $this->getThumb($post);
			$post['message'] = str_ireplace('prbreak]', 'prebreak]', $post['message']);
			
			if ($trimLoc = stripos($post['message'], '[prebreak]'))
			{
				$prbreak = '';
				
				if (($breakLoc = stripos($post['message'], '[/prebreak]', $trimLoc+10)) && ($length = $breakLoc - $trimLoc-10))
				{
					$link = XenForo_Link::buildPublicLink('full:threads', $post);
					$prbreak = " [url='".$link."']".substr($post['message'], $trimLoc+10, $length).'[/url]...';
				}
				
				$post['message'] = substr($post['message'], 0, $trimLoc).$prbreak;
			}
			else
			{
				$post['message'] = XenForo_Helper_String::wholeWordTrim($post['message'], $options['recentnews_truncate']);
			}

			$post['message'] = preg_replace('#\n{3,}#', "\n\n", trim($post['message']));
		}

		$options['parseBB'] = true;
		$options['count'] = $this->getCount($options);

        return $news;
	}

	public function getCount($options)
	{
        $count = $this->_getDb()->fetchRow("
			SELECT COUNT(*) AS total
				FROM xf_thread
				LEFT JOIN EWRporta_promotes ON (EWRporta_promotes.thread_id = xf_thread.thread_id)
			WHERE (xf_thread.node_id IN (".$options['recentnews_forum'].") OR EWRporta_promotes.promote_date < ?)
				AND xf_thread.discussion_state = 'visible'
		", XenForo_Application::$time);

		return $count['total'];
	}

	public function getThumb($post)
	{
		if (preg_match('#\[medio\](\d+)\[/medio\]#i', $post['message'], $matches))
		{
			if ($post['medio'] = $this->getModelFromCache('EWRmedio_Model_Media')->getMediaByID($matches[1]))
			{
				$post['message'] = str_ireplace('[medio]'.$matches[1].'[/medio]', '', $post['message']);
				$post['message'] = str_ireplace('[medio=full]'.$matches[1].'[/medio]', '', $post['message']);
				return $post;
			}
		}
		
		if (!empty($post['attachments']))
		{
			foreach ($post['attachments'] AS $attach)
			{
				if ($attach['thumbnailUrl'])
				{
					$post['attach'] = $attach;
					$post['message'] = str_ireplace('[attach]'.$attach['attachment_id'].'[/attach]', '', $post['message']);
					$post['message'] = str_ireplace('[attach=full]'.$attach['attachment_id'].'[/attach]', '', $post['message']);
					return $post;
				}
			}
		}

		if (preg_match('#\[img\](.+?)\[/img\]#i', $post['message'], $matches))
		{
			$post['image'] = $matches[1];
			$post['message'] = str_ireplace('[img]'.$matches[1].'[/img]', '', $post['message']);
			return $post;
		}

		return $post;
	}
}